/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule.elements;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.xcontent.ToXContentObject;
import org.quartz.Calendar;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;

public abstract class HumanReadableCronTrigger<T extends Trigger>
extends AbstractTrigger<T>
implements Trigger,
ToXContentObject {
    private static final long serialVersionUID = 8008213171103409490L;
    private List<CronTriggerImpl> generatedCronTriggers;
    private Date startTime = null;
    private Date endTime = null;
    private Date previousFireTime = null;
    protected TimeZone timeZone;

    protected abstract List<CronTriggerImpl> buildCronTriggers();

    protected void init() {
        this.generatedCronTriggers = this.buildCronTriggers();
        if (this.timeZone != null) {
            for (CronTriggerImpl trigger : this.generatedCronTriggers) {
                trigger.setTimeZone(this.timeZone);
            }
        }
    }

    public void setNextFireTime(Date nextFireTime) {
        CronTriggerImpl trigger = this.getNextFireTimeCronTrigger();
        if (trigger != null) {
            trigger.setNextFireTime(nextFireTime);
        } else {
            Date justBeforeNextFireTime = new Date(nextFireTime.getTime() - 1L);
            for (CronTriggerImpl delegate : this.generatedCronTriggers) {
                Date fireTime = delegate.getFireTimeAfter(justBeforeNextFireTime);
                delegate.setNextFireTime(fireTime);
            }
        }
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            delegate.setPreviousFireTime(previousFireTime);
        }
    }

    public void triggered(Calendar calendar) {
        Date oldNextFireTime;
        this.previousFireTime = oldNextFireTime = this.getNextFireTime();
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            if (delegate.getNextFireTime() != null && delegate.getNextFireTime().after(oldNextFireTime)) continue;
            delegate.setNextFireTime(this.getFireTimeAfter(delegate, oldNextFireTime, calendar));
            delegate.setPreviousFireTime(this.previousFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        Date result = null;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            Date delegateFirstFireTime = delegate.computeFirstFireTime(calendar);
            if (delegateFirstFireTime == null || result != null && !result.after(delegateFirstFireTime)) continue;
            result = delegateFirstFireTime;
        }
        return result;
    }

    public boolean mayFireAgain() {
        boolean result = false;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            result |= delegate.mayFireAgain();
        }
        return result;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            delegate.setStartTime(startTime);
        }
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            delegate.setEndTime(endTime);
        }
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getNextFireTime() {
        Date result = null;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            Date delegateNextFireTime = delegate.getNextFireTime();
            if (delegateNextFireTime == null || result != null && !result.after(delegateNextFireTime)) continue;
            result = delegateNextFireTime;
        }
        return result;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        Date result = null;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            Date delegateFireTimeAfter = delegate.getFireTimeAfter(afterTime);
            if (delegateFireTimeAfter == null || result != null && !result.after(delegateFireTimeAfter)) continue;
            result = delegateFireTimeAfter;
        }
        return result;
    }

    public Date getFinalFireTime() {
        Date result = null;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            Date delegateFinalFireTime = delegate.getFinalFireTime();
            if (delegateFinalFireTime == null || result != null && !result.before(delegateFinalFireTime)) continue;
            result = delegateFinalFireTime;
        }
        return result;
    }

    protected boolean validateMisfireInstruction(int candidateMisfireInstruction) {
        return candidateMisfireInstruction >= -1 && candidateMisfireInstruction <= 2;
    }

    public void updateAfterMisfire(Calendar cal) {
        int misfireInstruction = this.getMisfireInstruction();
        if (misfireInstruction == -1) {
            return;
        }
        if (misfireInstruction == 0) {
            misfireInstruction = 1;
        }
        if (misfireInstruction == 2) {
            Date now = new Date();
            for (CronTriggerImpl delegate : this.generatedCronTriggers) {
                delegate.setNextFireTime(this.getFireTimeAfter(delegate, now, cal));
            }
        } else if (misfireInstruction == 1) {
            Date now = new Date();
            CronTriggerImpl earliest = null;
            for (CronTriggerImpl delegate : this.generatedCronTriggers) {
                delegate.setNextFireTime(this.getFireTimeAfter(delegate, now, cal));
                if (earliest != null && !earliest.getNextFireTime().after(delegate.getNextFireTime())) continue;
                earliest = delegate;
            }
            earliest.setNextFireTime(new Date());
        }
    }

    public void updateWithNewCalendar(Calendar cal, long misfireThreshold) {
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            delegate.updateWithNewCalendar(cal, misfireThreshold);
        }
    }

    private Date getFireTimeAfter(CronTriggerImpl trigger, Date afterTime, Calendar cal) {
        Date result = trigger.getFireTimeAfter(afterTime);
        while (result != null && cal != null && !cal.isTimeIncluded(result.getTime())) {
            result = trigger.getFireTimeAfter(result);
        }
        return result;
    }

    private CronTriggerImpl getNextFireTimeCronTrigger() {
        CronTriggerImpl result = null;
        for (CronTriggerImpl delegate : this.generatedCronTriggers) {
            Date delegateNextFireTime = delegate.getNextFireTime();
            if (delegateNextFireTime == null || result != null && result.getNextFireTime() != null && !result.getNextFireTime().after(delegateNextFireTime)) continue;
            result = delegate;
        }
        return result;
    }

    protected static String format(TimeOfDay timeOfDay) {
        StringBuilder result = new StringBuilder();
        result.append(timeOfDay.getHour());
        result.append(':');
        if (timeOfDay.getMinute() < 10) {
            result.append('0');
        }
        result.append(timeOfDay.getMinute());
        if (timeOfDay.getSecond() != 0) {
            result.append(':');
            if (timeOfDay.getSecond() < 10) {
                result.append('0');
            }
            result.append(timeOfDay.getSecond());
        }
        return result.toString();
    }

    protected static TimeOfDay parseTimeOfDay(String string) throws ConfigValidationException {
        String expected = "Time of day: <HH>:<MM>:<SS>?";
        try {
            int minute;
            int colon = string.indexOf(58);
            if (colon == -1) {
                int hour = Integer.parseInt(string);
                if (hour < 0 || hour >= 24) {
                    throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").message("Hour must be between 0 and 23"));
                }
                return new TimeOfDay(hour, 0);
            }
            int hour = Integer.parseInt(string.substring(0, colon));
            int second = 0;
            int nextColon = string.indexOf(58, colon + 1);
            if (nextColon == -1) {
                minute = Integer.parseInt(string.substring(colon + 1));
            } else {
                minute = Integer.parseInt(string.substring(colon + 1, nextColon));
                second = Integer.parseInt(string.substring(nextColon + 1));
            }
            ValidationErrors validationErrors = new ValidationErrors();
            if (hour < 0 || hour >= 24) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").message("Hour must be between 0 and 23"));
            }
            if (minute < 0 || minute >= 60) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").message("Minute must be between 0 and 59"));
            }
            if (second < 0 || second >= 60) {
                throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").message("Second must be between 0 and 59"));
            }
            validationErrors.throwExceptionForPresentErrors();
            return new TimeOfDay(hour, minute, second);
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)string, (Object)"Time of day: <HH>:<MM>:<SS>?").cause((Throwable)e));
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

